---@meta

---@version >5.3
---
---
---
---[查看文档](http://www.lua.org/manual/5.4/manual.html#pdf-utf8)
---
---@class utf8lib
---
---用于精确匹配到一个 UTF-8 字节序列的模式，它假定处理的对象是一个合法的 UTF-8 字符串。
---
---[查看文档](http://www.lua.org/manual/5.4/manual.html#pdf-utf8.charpattern)
---
---@field charpattern string
utf8 = {}

---
---接收零或多个整数， 将每个整数转换成对应的 UTF-8 字节序列，并返回这些序列连接到一起的字符串。
---
---[查看文档](http://www.lua.org/manual/5.4/manual.html#pdf-utf8.char)
---
---@param code integer
---@vararg integer
---@return string
function utf8.char(code, ...) end

---
---返回一系列的值，可以让
---```lua
---for p, c in utf8.codes(s) do
---    body
---end
---```
---迭代出字符串 s 中所有的字符。 这里的 p 是位置（按字节数）而 c 是每个字符的编号。 如果处理到一个不合法的字节序列，将抛出一个错误。
---
---
---[查看文档](http://www.lua.org/manual/5.4/manual.html#pdf-utf8.codes)
---
---@param s    string
---@param lax? boolean
---@return fun():integer, integer
function utf8.codes(s, lax) end

---
---以整数形式返回 `s` 中 从位置 `i` 到 `j` 间（包括两端） 所有字符的编号。
---
---[查看文档](http://www.lua.org/manual/5.4/manual.html#pdf-utf8.codepoint)
---
---@param s    string
---@param i?   integer
---@param j?   integer
---@param lax? boolean
---@return integer code
---@return ...
function utf8.codepoint(s, i, j, lax) end

---
---返回字符串 `s` 中 从位置 `i` 到 `j` 间 （包括两端） UTF-8 字符的个数。
---
---[查看文档](http://www.lua.org/manual/5.4/manual.html#pdf-utf8.len)
---
---@param s    string
---@param i?   integer
---@param j?   integer
---@param lax? boolean
---@return integer?
---@return integer? errpos
function utf8.len(s, i, j, lax) end

---
---返回编码在 `s` 中的第 `n` 个字符的开始位置（按字节数） （从位置 `i` 处开始统计）。
---
---[查看文档](http://www.lua.org/manual/5.4/manual.html#pdf-utf8.offset)
---
---@param s string
---@param n integer
---@param i integer
---@return integer p
function utf8.offset(s, n, i) end

return utf8
